﻿using RoutingDeneme.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace RoutingDeneme.Controllers
{
    public class NewsController : Controller
    {
        List<News> news;

        public NewsController()
        {
            news = new List<News>();
            news.Add(new News() { Content = "Yapılan seçimlerin sonuçları açıklandı.", CreatedDate = DateTime.Now, Title = "SecimSonuclari", Id = 1 });
            news.Add(new News() { Content = "Hükümetin yaptığı yeni düzenleme, cezalarda artış öngörüyor.", CreatedDate = DateTime.Now, Title = "YeniKanunDuzenlemesi", Id = 2 });
            news.Add(new News() { Content = "Milli takımımızın aldığı bu galibiyette en büyük pay kalecimizin oldu.", CreatedDate = DateTime.Now, Title = "MilliTakimGalip", Id = 3 });
        }

        // GET: News
        public ActionResult Index()
        {
            return View();
        }

        //Tüm haberleri liste halinde getirir.
        public ActionResult GetNews()
        {
            return View(news);
        }

        //Paramatre olarak gelen id'ye göre haberi getirir.
        public ActionResult GetNew(int id)
        {
            return View(news.Where(i => i.Id == id).SingleOrDefault());
        }

        //Parametre olarak gelen title değerine göre haberi getirir.
        public ActionResult GetNewByTitle(string title)
        {
            return View(news.Where(i => i.Title == title).SingleOrDefault());
        }

        [HttpPost]
        //Burada listeye bir kayıt yapılmakta.
        public ActionResult SaveNew()
        {
            //id olarak listemizdeki en son eklenen id'nin sayısı bir arttırlıp kayıt yapılmaktadır.
            int id = (news.OrderByDescending(i => i.Id).SingleOrDefault().Id + 1);
            news.Add(new News()
            {
                Content = "Hava olaylarındaki anormallikler dikkat çekici olmaya başladı",
                CreatedDate = DateTime.Now,
                Title = "Hava Olaylarındaki Anormallikler",
                Id = id
            });
            return View();
        }

        //Bu alana yalnızca üyelerin girmesini istiyoruz.
        public ActionResult MemberArea()
        {
            return View();
        }

        //Eğer eşleşme olmazsa bu Action çalışacaktır.
        public ActionResult NotFound()
        {
            return View();
        }

        [Route("mvc5-test")]
        public ActionResult Mvc5()
        {
            return View();
        }
    }
}