﻿using RoutingDeneme.RouteConstraint;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace RoutingDeneme
{
    public class RouteConfig
    {
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.IgnoreRoute("robots.txt");

            //Asp.Net Mvc5 Route sistemini aktif ediyoruz.
            routes.MapMvcAttributeRoutes();

            routes.MapRoute(
                name: "GetNews",
                url: "haberler/tum-haberler",
                defaults: new { controller = "News", action = "GetNews" }
                );

            routes.MapRoute(
                name: "GetNew",
                url: "haberler/haber-detay/{id}",
                defaults: new { controller = "News", action = "GetNew", id = "" }
                );

            routes.MapRoute(
                name: "GetNewByTitle",
                url: "haberler/haber-detay-baslik/{title}",
                defaults: new { controller = "News", action = "GetNewByTitle", title = "" },
                constraints: new { title = @"[a-zA-Z]+" } //Burada yönlendirmenin yapılabilmesi için
                //title verisinin yalnızca metinsel olmasını şart koştuk.
                );

            routes.MapRoute(
                name: "SaveNew",
                url: "haberler/yeni-haber",
                defaults: new { controller = "News", action = "SaveNew" },
                constraints: new { method = new HttpMethodConstraint("POST") }
                //Yalnızca Post taleplerinde eşleşecek
                );

            routes.MapRoute(
              name: "MemberArea",
              url: "uyelik",
              defaults: new { controller = "News", action = "MemberArea" },
              constraints: new { test = new TestConstraint() }
                //Test Constraint'ten yeni bir örnek çağırıp, bağlıyoruz.
              );

            routes.MapRoute(
              name: "NotFound",
              url: "{*.}",//Yıldız her ne olursa anlamına geliyor.
                //Yukarıdaki eşleşmeleri deneyip, olmadığını gördükten sonra, NotFound'a yönelecektir.
              defaults: new { controller = "News", action = "NotFound" },
              constraints: new { notFound = new NotFoundConstraint() }
              );

            routes.MapRoute(
                name: "Default", //Yönlendirmenin adı
                url: "{controller}/{action}/{id}", //Talep olarak gelecek url yapısı
                defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional }  //Gelen talebin
                //yönlendirileceği, Controller ve Action, varsa parametreler
            );
        }
    }
}
